/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.udf;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.FigureEnumerator;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockGroup;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import DE.siemens.ad.pdraw.figures.PageLineFigure;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.pdraw.standard.LogoGridConstrainer;
import DE.siemens.ad.pdraw.standard.TreeImageBlockTool;
import DE.siemens.ad.udf.EditUDFFigure;
import DE.siemens.ad.udf.LogoDrawingUDF;
import DE.siemens.ad.udf.LogoDrawingViewUDF;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.util.Vector;

public class UDFTreeImageBlockTool
extends TreeImageBlockTool {
    public UDFTreeImageBlockTool(BlockGroup blockGroup) {
        super(blockGroup);
    }

    public boolean acceptDragAndDrop(DropTargetDragEvent dropTargetDragEvent) {
        if (super.acceptDragAndDrop(dropTargetDragEvent) && ((DropTarget)dropTargetDragEvent.getSource()).getComponent() instanceof LogoDrawingViewUDF) {
            Point newPoint = new Point(dropTargetDragEvent.getLocation().x, dropTargetDragEvent.getLocation().y);
            int zoom = ((LogoDrawingView)((DropTarget)dropTargetDragEvent.getSource()).getComponent()).getZoomManager().getZoom();
            double scale = (double)zoom / 100.0;
            newPoint.x = (int)((double)newPoint.x * (1.0 / scale));
            newPoint.y = (int)((double)newPoint.y * (1.0 / scale));
            if (((LogoDrawingViewUDF)((DropTarget)dropTargetDragEvent.getSource()).getComponent()).canHoldFiugre(newPoint)) {
                return true;
            }
        }
        return false;
    }

    protected BlockFigure getBlockFigure(Block block, Point p) {
        return super.getBlockFigure(block, p);
    }

    protected boolean testInputArea(int x, int y, DrawingView view) {
        if (((LogoDrawingView)view).getConstrainer() instanceof LogoGridConstrainer) {
            Point constraintPoint = ((LogoGridConstrainer)((LogoDrawingView)view).getConstrainer()).constrainPoint(new Point(x, y));
            x = constraintPoint.x;
            y = constraintPoint.y;
        }
        boolean retValue = false;
        int imageWidth = 24;
        int imageHeight = 33;
        Vector intersected = ((LogoDrawing)view.drawing()).getFiguresIntersectRectangle(new Rectangle(x, y, imageWidth, imageHeight));
        FigureEnumerator fEnum = new FigureEnumerator(intersected);
        int ignoreFigureCounter = 0;
        while (fEnum.hasMoreElements()) {
            Figure f = fEnum.nextFigure();
            if (!(f instanceof FixedElbowConnection) && !(f instanceof PageLineFigure) && !(f instanceof EditUDFFigure)) continue;
            ++ignoreFigureCounter;
        }
        if (intersected.size() > ignoreFigureCounter) {
            retValue = true;
        } else if (view.drawing() instanceof LogoDrawingUDF) {
            retValue = !((LogoDrawingViewUDF)view).canHoldFiugre(new Point(x, y));
        }
        return retValue;
    }
}

